/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.GUI.debugger;

import emulator.assembler.CodeAnalyzer;
import java.util.Observable;
import java.util.Observer;

public class AnalyzerThread
extends Thread {
    private CodeAnalyzer analyzer;
    private AnalyzerObservable observable = new AnalyzerObservable();

    @Override
    public void run() {
        this.observable.setAnalyzerRunning(true);
        try {
            this.analyzer.runAnalysis();
        }
        finally {
            this.observable.setAnalyzerRunning(false);
        }
    }

    public CodeAnalyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(CodeAnalyzer analyzer) {
        this.analyzer = analyzer;
    }

    public void addObserver(Observer codeAnalyzerObserver) {
        this.observable.addObserver(codeAnalyzerObserver);
    }

    class AnalyzerObservable
    extends Observable {
        private boolean analyzer_running = false;

        AnalyzerObservable() {
        }

        public boolean getAnalyzerRunning() {
            return this.analyzer_running;
        }

        public void setAnalyzerRunning(boolean analyzer_running) {
            this.analyzer_running = analyzer_running;
            this.setChanged();
            this.notifyObservers(analyzer_running);
        }
    }
}

